/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.mccs;

import com.quantumdata.mccs.CmdValueDetails;
import com.quantumdata.mccs.Constants;
import javax.swing.JTextField;

public class VCPCodes {
    private String cmdName;
    private String vcpCode;
    private String type;
    private String funcType;
    private JTextField jTextFieldName;
    private boolean supported = false;
    private int numOfDetails = 0;
    private CmdValueDetails[] valueDetails;
    private int valueForReserved = 0;

    public VCPCodes(String string, String string2, String string3, String string4) {
        this.init(string, string2, string3, string4);
    }

    public VCPCodes(String string, String string2, String string3, String string4, int n) {
        this.init(string, string2, string3, string4);
        this.numOfDetails = n;
        this.valueDetails = new CmdValueDetails[this.numOfDetails];
    }

    private void init(String string, String string2, String string3, String string4) {
        this.cmdName = string;
        this.vcpCode = string2;
        this.type = string3;
        this.funcType = string4;
        this.jTextFieldName = Constants.createFieldNameText(this.getNameWithCode());
    }

    public String getCmdName() {
        return this.cmdName;
    }

    public String getVcpCode() {
        return this.vcpCode;
    }

    public String getNameWithCode() {
        return this.cmdName + " - " + this.vcpCode + "h";
    }

    public String getType() {
        return this.type;
    }

    public String getFuncType() {
        return this.funcType;
    }

    public JTextField getNameField() {
        return this.jTextFieldName;
    }

    public boolean isSupported() {
        return this.supported;
    }

    public void setSupported(boolean bl) {
        this.supported = bl;
    }

    public int getNumOfDetails() {
        return this.numOfDetails;
    }

    public int getNumOfSupportedDetails() {
        int n = 0;
        for (int i = 0; i < this.numOfDetails; ++i) {
            if (!this.valueDetails[i].isSupported()) continue;
            ++n;
        }
        return n;
    }

    public void setValueDetails(int n, String string, String string2) {
        this.valueDetails[n] = new CmdValueDetails(string, string2);
    }

    public String getAdditionalDetails(String string) {
        String string2 = "";
        if (this.numOfDetails != 0) {
            for (int i = 0; i < this.numOfDetails; ++i) {
                if (!string.equalsIgnoreCase(this.valueDetails[i].getCmdValue())) continue;
                string2 = "\n     " + this.valueDetails[i].getDetailWithValue();
                this.valueDetails[i].setSupported(true);
                break;
            }
            if (string2 == "") {
                string2 = "\n     " + string + "h: Reserved";
            }
        }
        return string2;
    }

    public String getDetailByCmdValue(int n) {
        String string = "Reserved";
        for (int i = 0; i < this.numOfDetails; ++i) {
            if (!Integer.toHexString(n).equalsIgnoreCase(this.valueDetails[i].getCmdValue()) || (string = this.valueDetails[i].getString()) != null) continue;
            string = "Reserved";
        }
        return string;
    }

    public String getDetailByIndex(int n) {
        return this.valueDetails[n].getString();
    }

    public void unSupportAllDetails() {
        for (int i = 0; i < this.numOfDetails; ++i) {
            this.valueDetails[i].setSupported(false);
        }
    }

    public String getDetailValue(int n) {
        return this.valueDetails[n].getCmdValue();
    }

    public void setValueForReserved(int n) {
        this.valueForReserved = n;
    }

    public String getValueForReserved() {
        return Integer.toHexString(this.valueForReserved);
    }
}

